<!-- Recent Activities & Quick Actions -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-4 lg:gap-6 mb-6">
    <!-- Recent Orders -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-shopping-bag text-blue-600 dark:text-blue-400 mr-2"></i>
                Pesanan Terbaru
            </h3>
            <a href="{{ route('admin.master.orders.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="space-y-3">
            @forelse($recentData['recent_orders'] ?? [] as $order)
                <div class="flex items-center justify-between p-4 bg-gradient-to-r from-gray-50 to-gray-100/50 dark:from-gray-700/30 dark:to-gray-700/20 rounded-lg transition-all border border-gray-200 dark:border-gray-600 group">
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-gray-900 dark:text-white truncate mb-1">
                            #{{ $order->id }} - {{ $order->product->product_title ?? 'N/A' }}
                        </p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            <i class="fas fa-user text-gray-400 mr-1"></i>
                            {{ $order->user->name ?? $order->customer_email ?? 'Guest' }} • 
                            <i class="fas fa-calendar text-gray-400 ml-2 mr-1"></i>
                            {{ $order->created_at->format('d M Y') }}
                        </p>
                    </div>
                    <span class="ml-3 inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold
                        {{ $order->order_status === 'diterima' ? 'bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-400' : 
                           ($order->order_status === 'ditolak' ? 'bg-red-100 text-red-700 dark:bg-red-900/30 dark:text-red-400' : 
                           'bg-yellow-100 text-yellow-700 dark:bg-yellow-900/30 dark:text-yellow-400') }}">
                        {{ ucfirst($order->order_status) }}
                    </span>
                </div>
            @empty
                <div class="text-center py-8">
                    <i class="fas fa-inbox text-gray-300 dark:text-gray-600 text-3xl mb-2"></i>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Belum ada pesanan</p>
                </div>
            @endforelse
        </div>
    </div>

    <!-- Recent Inquiries -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-envelope-open-text text-purple-600 dark:text-purple-400 mr-2"></i>
                Penawaran Terbaru
            </h3>
            <a href="{{ route('admin.product-inquiries.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="space-y-3">
            @forelse($recentData['recent_inquiries'] ?? [] as $inquiry)
                <div class="flex items-center justify-between p-4 bg-gradient-to-r from-gray-50 to-gray-100/50 dark:from-gray-700/30 dark:to-gray-700/20 rounded-lg transition-all border border-gray-200 dark:border-gray-600 group">
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-gray-900 dark:text-white truncate mb-1">
                            {{ $inquiry->product->product_title ?? 'N/A' }}
                        </p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            <i class="fas fa-user text-gray-400 mr-1"></i>
                            {{ $inquiry->name }} • 
                            <i class="fas fa-calendar text-gray-400 ml-2 mr-1"></i>
                            {{ $inquiry->created_at->format('d M Y') }}
                        </p>
                    </div>
                    @if(!$inquiry->is_read)
                        <span class="ml-3 inline-flex items-center justify-center w-6 h-6 rounded-full bg-red-500 text-white text-xs font-bold">
                            !
                        </span>
                    @endif
                </div>
            @empty
                <div class="text-center py-8">
                    <i class="fas fa-inbox text-gray-300 dark:text-gray-600 text-3xl mb-2"></i>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Belum ada penawaran</p>
                </div>
            @endforelse
        </div>
    </div>

    <!-- Active Productions & Quick Stats -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-industry text-indigo-600 dark:text-indigo-400 mr-2"></i>
                Produksi Aktif
            </h3>
            <a href="{{ route('admin.productions.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="space-y-3">
            @forelse($recentData['active_productions'] ?? [] as $production)
                <div class="flex items-center justify-between p-4 bg-gradient-to-r from-gray-50 to-gray-100/50 dark:from-gray-700/30 dark:to-gray-700/20 rounded-lg transition-all border border-gray-200 dark:border-gray-600 group">
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-gray-900 dark:text-white truncate mb-1">
                            #{{ $production->id }} - {{ $production->product->product_title ?? 'N/A' }}
                        </p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            <i class="fas fa-user-cog text-gray-400 mr-1"></i>
                            {{ $production->teknisi->name ?? 'Belum ditugaskan' }}
                        </p>
                    </div>
                    <span class="ml-3 inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold bg-blue-100 text-blue-700 dark:bg-blue-900/30 dark:text-blue-400">
                        {{ ucfirst($production->status) }}
                    </span>
                </div>
            @empty
                <div class="text-center py-8">
                    <i class="fas fa-inbox text-gray-300 dark:text-gray-600 text-3xl mb-2"></i>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Tidak ada produksi aktif</p>
                </div>
            @endforelse
        </div>
    </div>
</div>

