<!-- Material Form Card -->
<div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 relative">
    <button type="button"
        class="absolute top-4 right-4 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200"
        onclick="removeItem(this)">
        <i class="fas fa-times text-sm"></i>
    </button>

    <!-- Header Card -->
    <div class="flex items-center mb-5">
        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Bahan</h3>
    </div>

    <!-- Basic Information -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
        <!-- Material Code -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kode Bahan</label>
            <input type="text" name="materials[{{ $index }}][material_code]"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Jika kosong, otomatis dibuat unik">
        </div>

        <!-- Nama Bahan -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Nama Bahan <span class="text-red-500">*</span>
            </label>
            <input type="text" name="materials[{{ $index }}][name]" required
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Masukkan nama bahan">
        </div>

        <!-- Kategori -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kategori</label>
            <input type="text" name="materials[{{ $index }}][category]"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Masukkan kategori bahan">
        </div>
    </div>

    <!-- Stock & Pricing -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-5">
        <!-- Stok -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Stok <span class="text-red-500">*</span>
            </label>
            <input type="number" name="materials[{{ $index }}][stock]" min="0" required
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="0">
        </div>

        <!-- Satuan -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Satuan</label>
            <input type="text" name="materials[{{ $index }}][unit]"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="cth: kg, liter, meter">
        </div>

        <!-- Harga -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Harga Satuan (Rp)</label>
            <input type="number" name="materials[{{ $index }}][price]" min="0"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="cth: 15000">
        </div>

        <!-- Supplier -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Supplier</label>
            <input type="text" name="materials[{{ $index }}][supplier]"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Jika kosong, otomatis '-'">
        </div>
    </div>

    <!-- Description & Image -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-5 mb-5">
        <!-- Deskripsi -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Deskripsi</label>
            <textarea name="materials[{{ $index }}][description]" rows="4"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 resize-none text-sm"
                placeholder="Tuliskan deskripsi bahan jika perlu..."></textarea>
        </div>

        <!-- Gambar -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Gambar</label>
            <div class="space-y-3">
                <input type="file" name="materials[{{ $index }}][image]" accept="image/*" onchange="previewImage(this)"
                    class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
                
                <!-- Image Preview -->
                <div class="relative inline-block w-full max-w-xs">
                    <img src="" alt="Preview" 
                        class="w-full h-48 object-contain rounded-lg border border-gray-200 dark:border-gray-600 bg-gray-50 dark:bg-gray-700/50 hidden"
                        style="background: transparent;">
                    
                    <!-- Remove Button -->
                    <button type="button" onclick="removeImage(this)"
                        class="absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 hidden">
                        <i class="fas fa-times text-sm"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Status -->
    <div class="flex items-center">
        <input type="checkbox" name="materials[{{ $index }}][is_active]" value="1" checked
            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700">
        <label class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Aktif</label>
    </div>
</div>

