@extends('layouts.admin')

@section('title', 'Dashboard Admin - Barang Management')

@section('content')
    <!-- Breadcrumb -->
    @php
    $breadcrumbs = [
        ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
        ['label' => 'Master', 'url' => '#'],
        ['label' => 'Barang', 'url' => route('admin.master.materials.index')]
    ];
    @endphp
    <x-breadcrumb :items="$breadcrumbs" />

    <!-- Notifikasi Modern -->
    <x-admin-notification />

    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white mb-4">Barang Management</h1>

        <!-- Filter Section -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <form method="GET" action="{{ route('admin.master.materials.index') }}" id="filterForm" class="flex flex-col sm:flex-row items-end gap-3">
                <!-- Search Bar -->
                <div class="relative flex-1 w-full sm:w-auto">
                    <input type="text" name="search" id="searchInput" value="{{ request('search') }}" placeholder="Cari material/sparepart..."
                        class="form-input-search" />
                    <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                    @if (request('search'))
                        <button type="button" onclick="clearSearch()"
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                            <i class="fas fa-times"></i>
                        </button>
                    @endif
                </div>

                <!-- Type Filter -->
                <div class="relative w-full sm:w-auto">
                    <select name="type" id="typeFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Tipe</option>
                        <option value="material" {{ request('type') === 'material' ? 'selected' : '' }}>Material</option>
                        <option value="sparepart" {{ request('type') === 'sparepart' ? 'selected' : '' }}>Sparepart</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Status Filter -->
                <div class="relative w-full sm:w-auto">
                    <select name="status" id="statusFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Status</option>
                        <option value="1" {{ request('status') === '1' ? 'selected' : '' }}>Aktif</option>
                        <option value="0" {{ request('status') === '0' ? 'selected' : '' }}>Nonaktif</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center gap-2 w-full sm:w-auto">
                    <button type="button" id="bulkDeleteBtn" onclick="confirmBulkDelete()" disabled class="action-btn-danger">
                        <i class="fas fa-trash mr-2"></i>
                        <span>Hapus Terpilih</span>
                    </button>
                    <!-- Action Dropdown -->
                    <div class="relative" x-data="{ open: false }">
                        <button type="button" @click="open = !open" class="action-btn-primary">
                            <i class="fas fa-plus mr-2"></i>
                            <span>Tambah</span>
                            <i class="fas fa-chevron-down ml-2 text-sm"></i>
                        </button>
                        <div x-show="open" x-cloak @click.away="open = false" x-transition style="display: none;"
                            class="absolute right-0 mt-2 w-48 bg-white dark:bg-gray-800 rounded-lg shadow-lg border border-gray-200 dark:border-gray-700 z-50">
                            <div class="py-1">
                                <a href="{{ route('admin.master.materials.create', ['type' => 'material']) }}"
                                    class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                    <i class="fas fa-cube mr-3 text-green-600"></i>
                                    Tambah Material
                                </a>
                                <a href="{{ route('admin.master.materials.create', ['type' => 'sparepart']) }}"
                                    class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                    <i class="fas fa-cog mr-3 text-blue-600"></i>
                                    Tambah Sparepart
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabel Gabungan (tanpa tab) -->

    <!-- Quick Stats Gabungan -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-layer-group text-blue-600 dark:text-blue-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Gabungan</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white">{{ $totalItems ?? $combinedItems->total() }}</p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg">
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Aktif</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white">{{ $activeItems ?? 0 }}</p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-yellow-600 dark:text-yellow-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Stock Rendah</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white">{{ $lowStockItems ?? 0 }}</p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-red-100 dark:bg-red-900/40 rounded-lg">
                    <i class="fas fa-times-circle text-red-600 dark:text-red-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Nonaktif</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white">{{ $inactiveItems ?? 0 }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Filters Info -->
    @if (request('search') || request('type') || request()->has('status'))
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>
                
                @if (request('search'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-search mr-1"></i>
                        Pencarian: "{{ request('search') }}"
                        <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('type'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                        <i class="fas fa-{{ request('type') === 'material' ? 'cube' : 'cog' }} mr-1"></i>
                        Tipe: {{ request('type') === 'material' ? 'Material' : 'Sparepart' }}
                        <button onclick="clearFilter('type')" class="ml-2 hover:text-green-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request()->has('status'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800 dark:bg-purple-800 dark:text-purple-200">
                        <i class="fas fa-toggle-{{ request('status') == '1' ? 'on' : 'off' }} mr-1"></i>
                        Status: {{ request('status') == '1' ? 'Aktif' : 'Nonaktif' }}
                        <button onclick="clearFilter('status')" class="ml-2 hover:text-purple-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    @endif

    <!-- Table Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="overflow-x-auto">
            <!-- Legend per Tipe -->
            <div class="flex items-center gap-3 px-4 pt-4 pb-2">
                <span class="inline-flex items-center gap-2 px-2.5 py-1 text-xs font-semibold rounded-md bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300">
                    <i class="fas fa-cube"></i> Material
                </span>
                <span class="inline-flex items-center gap-2 px-2.5 py-1 text-xs font-semibold rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-300">
                    <i class="fas fa-cog"></i> Sparepart
                </span>
            </div>
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="w-12 px-4 py-3.5 text-center">
                            <input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)"
                                class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        </th>
                        <th class="w-16 px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">No</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Gambar</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Kode</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Nama</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Tipe</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Brand</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">No Part</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Stock</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Unit</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Harga</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Status</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse ($combinedItems as $item)
                        <tr class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200 cursor-pointer">
                            <!-- Checkbox -->
                            <td class="px-4 py-4 text-center align-middle">
                                <input type="checkbox" name="item_ids[]" 
                                    data-item-id="{{ $item['id'] }}" 
                                    data-item-type="{{ $item['type'] }}"
                                    onchange="updateBulkDeleteButton()"
                                    class="item-checkbox w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                            </td>
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100 text-center align-middle">{{ $combinedItems->firstItem() + $loop->index }}</td>
                            <td class="px-6 py-4 text-center align-middle">
                                @if($item['image_path'])
                                    <img src="{{ $item['image_path'] }}" alt="{{ $item['name'] }}"
                                        class="w-14 h-14 object-contain rounded" style="background: transparent;">
                                @else
                                    <div class="w-14 h-14 rounded bg-gray-100 dark:bg-gray-600 flex items-center justify-center">
                                        <i class="fas fa-image text-gray-400 dark:text-gray-500 text-lg"></i>
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-xs font-medium text-gray-500 dark:text-gray-400 align-middle">{{ $item['code'] }}</td>
                            <td class="px-6 py-4 text-sm font-medium text-gray-900 dark:text-gray-100 align-middle">
                                <div class="flex items-center gap-2">
                                    {{ $item['name'] }}
                                    @if(($item['damaged_stock'] ?? 0) > 0)
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-200" 
                                              title="Jumlah unit rusak: {{ number_format($item['damaged_stock'], 0, ',', '.') }} {{ $item['unit'] }}">
                                            <i class="fas fa-exclamation-triangle mr-1"></i>
                                            {{ number_format($item['damaged_stock'], 0, ',', '.') }}
                                        </span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-6 py-4 text-center align-middle">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md {{ $item['type'] === 'material' ? 'bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300' : 'bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-300' }}">
                                    <i class="fas {{ $item['type'] === 'material' ? 'fa-cube' : 'fa-cog' }} text-xs"></i>
                                    {{ ucfirst($item['type']) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300 align-middle">{{ $item['brand'] }}</td>
                            <td class="px-6 py-4 text-xs text-gray-500 dark:text-gray-400 align-middle">{{ $item['part_number'] }}</td>
                            <td class="px-6 py-4 text-center align-middle">
                                <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md {{ $item['stock'] <= 5 ? 'bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-300' : 'bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300' }}">{{ $item['stock'] }}</span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300 text-center align-middle">{{ $item['unit'] }}</td>
                            <td class="px-6 py-4 text-sm font-semibold text-gray-900 dark:text-gray-100 text-center align-middle">Rp {{ number_format($item['price'], 0, ',', '.') }}</td>
                            <td class="px-6 py-4 text-center align-middle">
                                <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md {{ $item['is_active'] ? 'bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300' : 'bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-300' }}">{{ $item['is_active'] ? 'Aktif' : 'Nonaktif' }}</span>
                            </td>
                            <td class="px-6 py-4 text-center align-middle">
                                <div class="flex items-center justify-center space-x-2" style="display: flex; align-items: center; justify-content: center;">
                                    <a href="{{ route('admin.master.materials.show', ['id' => $item['id'], 'type' => $item['type']]) }}?{{ http_build_query(request()->only(['page', 'search', 'type'])) }}" 
                                        class="inline-flex items-center justify-center w-9 h-9 text-indigo-600 dark:text-indigo-400 hover:text-indigo-700 dark:hover:text-indigo-300 hover:bg-indigo-50 dark:hover:bg-indigo-900/20 rounded transition-colors duration-200"
                                        title="Detail">
                                        <i class="fas fa-eye text-base"></i>
                                    </a>
                                    <a href="{{ route('admin.master.materials.edit', ['id' => $item['id'], 'type' => $item['type']]) }}?{{ http_build_query(request()->only(['page', 'search', 'type'])) }}" 
                                        class="inline-flex items-center justify-center w-9 h-9 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                                        title="Edit">
                                        <i class="fas fa-edit text-base"></i>
                                    </a>
                                    <form action="{{ route('admin.master.materials.destroy', ['id' => $item['id'], 'type' => $item['type']]) }}" method="POST" class="inline m-0 p-0" style="display: inline-block; margin: 0; padding: 0;" onsubmit="return confirmDelete(event, '{{ $item['type'] }}')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                            class="inline-flex items-center justify-center w-9 h-9 text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/20 rounded transition-colors duration-200"
                                            title="Hapus">
                                            <i class="fas fa-trash text-base"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="13" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                <i class="fas fa-layer-group text-4xl mb-3 block text-gray-400 dark:text-gray-500"></i>
                                <p>Belum ada data gabungan</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        @if ($combinedItems->hasPages())
            <div
                class="flex items-center justify-between px-4 py-3 border-t border-gray-200 dark:border-gray-700 text-sm bg-gray-50 dark:bg-gray-800">
        
                <!-- Info -->
                <div class="text-gray-600 dark:text-gray-400">
                    Menampilkan
                    <span class="font-medium">{{ $combinedItems->firstItem() }}</span>
                    –
                    <span class="font-medium">{{ $combinedItems->lastItem() }}</span>
                    dari
                    <span class="font-medium">{{ $combinedItems->total() }}</span>
                    data
                </div>
        
                <!-- Pagination -->
                <div>
                    {{ $combinedItems->onEachSide(1)->links() }}
                </div>
            </div>
        @endif

    </div>

    <!-- Form Bulk Delete Tersembunyi -->
    <form id="bulkDeleteForm" action="{{ route('admin.master.materials.bulkDestroy') }}" method="POST" class="hidden">
        @csrf
        @method('DELETE')
        <input type="hidden" name="items" id="bulkDeleteItems">
    </form>

    <script>
        function toggleSelectAll(checkbox) {
            const checkboxes = document.querySelectorAll('.item-checkbox');
            checkboxes.forEach(cb => {
                cb.checked = checkbox.checked;
            });
            updateBulkDeleteButton();
        }

        function updateBulkDeleteButton() {
            const checkboxes = document.querySelectorAll('.item-checkbox:checked');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
            
            if (checkboxes.length > 0) {
                bulkDeleteBtn.disabled = false;
            } else {
                bulkDeleteBtn.disabled = true;
                document.getElementById('selectAll').checked = false;
            }
        }

        function confirmBulkDelete() {
            const checkboxes = document.querySelectorAll('.item-checkbox:checked');
            const items = [];

            checkboxes.forEach(cb => {
                items.push({
                    id: parseInt(cb.dataset.itemId),
                    type: cb.dataset.itemType
                });
            });

            if (items.length === 0) {
                return;
            }

            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: `Anda akan menghapus ${items.length} item secara permanen!`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc2626',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true,
                customClass: {
                    popup: 'rounded-lg',
                    confirmButton: 'px-4 py-2 rounded-md font-medium',
                    cancelButton: 'px-4 py-2 rounded-md font-medium'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('bulkDeleteItems').value = JSON.stringify(items);
                    document.getElementById('bulkDeleteForm').submit();
                }
            });
        }

        function confirmDelete(event, type) {
            event.preventDefault();
            const form = event.target.closest('form');
            
            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: `Data ${type} ini akan dihapus secara permanen!`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc2626',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true,
                customClass: {
                    popup: 'rounded-lg',
                    confirmButton: 'px-4 py-2 rounded-md font-medium',
                    cancelButton: 'px-4 py-2 rounded-md font-medium'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        }

        // Submit filter dengan parameter yang bersih
        function submitFilter() {
            const params = new URLSearchParams();
            
            // Ambil nilai dari setiap input/select
            const search = document.getElementById('searchInput')?.value?.trim() || '';
            const type = document.getElementById('typeFilter')?.value || '';
            const status = document.getElementById('statusFilter')?.value || '';
            
            // Hanya tambahkan parameter yang memiliki nilai
            if (search) {
                params.append('search', search);
            }
            if (type) {
                params.append('type', type);
            }
            if (status) {
                params.append('status', status);
            }
            
            // Redirect dengan parameter yang bersih
            const url = '{{ route("admin.master.materials.index") }}' + (params.toString() ? '?' + params.toString() : '');
            window.location.href = url;
        }

        // Clear search only
        function clearSearch() {
            const url = new URL(window.location);
            url.searchParams.delete('search');
            window.location.href = url.toString();
        }

        // Clear individual filter
        function clearFilter(filterName) {
            const url = new URL(window.location);
            url.searchParams.delete(filterName);
            window.location.href = url.toString();
        }

        // Clear all filters
        function clearAllFilters() {
            window.location.href = '{{ route("admin.master.materials.index") }}';
        }

        // Submit form search dengan Enter
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        submitFilter();
                    }
                });
            }
        });
    </script>

    <style>
        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }
        
        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        
        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }
        
        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .action-btn-primary,
        .action-btn-danger {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            padding: 0 1rem !important;
            margin: 0 !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            font-weight: 500;
            border-radius: 0.5rem;
            transition: all 0.2s;
            white-space: nowrap;
        }
        
        .action-btn-primary {
            background-color: rgb(59 130 246);
            color: white;
        }
        
        .action-btn-primary:hover {
            background-color: rgb(37 99 235);
        }
        
        .action-btn-danger {
            background-color: rgb(239 68 68);
            color: white;
        }
        
        .action-btn-danger:hover:not(:disabled) {
            background-color: rgb(220 38 38);
        }
        
        .action-btn-danger:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
    </style>
    
@endsection