@extends('layouts.admin')

@section('title', ($type ?? 'material') === 'sparepart' ? 'Edit Sparepart' : 'Edit Bahan')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.master.materials.index', isset($queryParams) ? $queryParams : []) }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">
                {{ ($type ?? 'material') === 'sparepart' ? 'Edit Sparepart' : 'Edit Bahan' }}
            </h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <form action="{{ route('admin.master.materials.update', ['id' => ($type ?? 'material') === 'sparepart' ? $sparepart->id : $material->id, 'type' => $type ?? 'material']) }}" method="POST" enctype="multipart/form-data" class="p-5">
            @csrf
            @method('PUT')
            <input type="hidden" name="type" value="{{ $type ?? 'material' }}">
            
            <!-- Hidden inputs untuk menyimpan query parameters -->
            @if(isset($queryParams))
                @foreach($queryParams as $key => $value)
                    @if($value)
                        <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                    @endif
                @endforeach
            @endif

            @if(($type ?? 'material') === 'sparepart')
                @include('admin.master.materials.partials.edit-sparepart-form')
            @else
                @include('admin.master.materials.partials.edit-material-form')
            @endif

            <!-- Action Buttons -->
            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('admin.master.materials.index', isset($queryParams) ? $queryParams : []) }}"
                    class="px-6 py-3 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium">
                    Batal
                </a>
                <button type="submit"
                    class="px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Update</span>
                </button>
            </div>
        </form>
    </div>

    <script>
        // Toggle damage fields berdasarkan jumlah unit rusak
        function toggleDamageFields() {
            const damagedStockInput = document.querySelector('input[name="damaged_stock"]');
            if (!damagedStockInput) return;
            
            const damagedStock = damagedStockInput.value;
            const damageNotesSection = document.getElementById('damage-notes-section');
            const damageDateSection = document.getElementById('damage-date-section');
            
            if (damageNotesSection && damageDateSection) {
                if (damagedStock > 0) {
                    damageNotesSection.style.display = 'block';
                    damageDateSection.style.display = 'block';
                } else {
                    damageNotesSection.style.display = 'none';
                    damageDateSection.style.display = 'none';
                }
            }
        }

        // Event listener untuk perubahan jumlah unit rusak
        document.addEventListener('DOMContentLoaded', function() {
            const damagedStockInput = document.querySelector('input[name="damaged_stock"]');
            if (damagedStockInput) {
                damagedStockInput.addEventListener('input', toggleDamageFields);
                // Check initial state
                toggleDamageFields();
            }
        });

        function previewImage(input) {
            const file = input.files[0];
            const previewContainer = document.getElementById('newImagePreview');
            const img = previewContainer.querySelector('img');
            const removeBtn = document.getElementById('removeNewImageBtn');

            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    img.src = e.target.result;
                    img.classList.remove('hidden');
                    removeBtn.classList.remove('hidden');
                    previewContainer.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else {
                img.src = '';
                img.classList.add('hidden');
                removeBtn.classList.add('hidden');
                previewContainer.classList.add('hidden');
            }
        }

        function removeImage(button) {
            const container = button.closest('div');
            const img = container.querySelector('img');
            const input = document.querySelector('input[type=file]');

            input.value = '';
            img.src = '';
            img.classList.add('hidden');
            button.classList.add('hidden');
            container.classList.add('hidden');
        }

        function removeExistingImage(button) {
            const container = button.closest('div');
            container.remove();
            // Set hidden input to indicate removal
            const hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = 'remove_image';
            hiddenInput.value = '1';
            document.querySelector('form').appendChild(hiddenInput);
        }
    </script>
@endsection
