@extends('layouts.admin')

@section('title', 'Detail Serah Terima - Order #' . $order->id)

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.handover.index') }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Serah Terima Order #{{ $order->id }}</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    {{ $order->customer_name }} · {{ $order->product->product_title ?? 'N/A' }}
                </p>
            </div>
        </div>
        @if($order->handover_status === 'confirmed')
        <div class="flex items-center space-x-2">
            <a href="{{ route('admin.handover.print.preview', $order) }}" 
                target="_blank"
                class="inline-flex items-center px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-eye mr-2 text-sm"></i>
                <span>Preview & Cetak</span>
            </a>
        </div>
        @endif
    </div>

    <!-- Success/Error Messages -->
    @if(session('success'))
    <div class="mb-6 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
    </div>
    @endif

    @if($errors->any())
    <div class="mb-6 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg">
        <ul class="list-disc list-inside">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <!-- Progress Timeline -->
    <div class="mb-6 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 transition-colors duration-300">
        <div class="flex items-center justify-between">
            @php
                $steps = [
                    ['key' => 'pending', 'label' => 'Persiapan', 'icon' => 'fa-box'],
                    ['key' => 'ready', 'label' => 'Siap Kirim', 'icon' => 'fa-check'],
                    ['key' => 'delivered', 'label' => 'Diserahkan', 'icon' => 'fa-truck'],
                    ['key' => 'confirmed', 'label' => 'Selesai', 'icon' => 'fa-check-double'],
                ];
                $currentIndex = array_search($order->handover_status ?? 'pending', array_column($steps, 'key'));
                if ($currentIndex === false) $currentIndex = 0;
            @endphp
            @foreach($steps as $index => $step)
            <div class="flex flex-col items-center flex-1 relative">
                @if($index > 0)
                <div class="absolute left-0 right-1/2 top-5 h-1 {{ $index <= $currentIndex ? 'bg-green-500' : 'bg-gray-200 dark:bg-gray-600' }} -translate-y-1/2" style="z-index: 0;"></div>
                @endif
                @if($index < count($steps) - 1)
                <div class="absolute left-1/2 right-0 top-5 h-1 {{ $index < $currentIndex ? 'bg-green-500' : 'bg-gray-200 dark:bg-gray-600' }} -translate-y-1/2" style="z-index: 0;"></div>
                @endif
                <div class="w-10 h-10 rounded-full flex items-center justify-center z-10 {{ $index <= $currentIndex ? 'bg-green-500 text-white' : 'bg-gray-200 dark:bg-gray-600 text-gray-500 dark:text-gray-400' }}">
                    <i class="fas {{ $step['icon'] }} text-sm"></i>
                </div>
                <span class="text-xs mt-2 font-medium {{ $index <= $currentIndex ? 'text-green-600 dark:text-green-400' : 'text-gray-500 dark:text-gray-400' }}">{{ $step['label'] }}</span>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Product Image -->
    @if ($order->product && $order->product->product_image)
        <div class="mb-6 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center gap-4">
                <div class="flex-shrink-0">
                    <img src="{{ asset('uploads/products/' . $order->product->product_image) }}"
                        alt="{{ $order->product->product_title }}"
                        class="w-32 h-32 object-contain rounded-lg"
                        style="background: transparent;">
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-1">{{ $order->product->product_title }}</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Produk Pesanan</p>
                </div>
            </div>
        </div>
    @endif

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-6">
        <!-- Order Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                    <i class="fas fa-info-circle text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Order</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Produk:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $order->product->product_title ?? 'N/A' }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Jumlah:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $order->quantity }} unit</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Total:</span>
                    <span class="text-xs font-semibold text-indigo-600 dark:text-indigo-400">Rp {{ number_format($order->total_price, 0, ',', '.') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Teknisi:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $order->production->teknisi->name ?? 'N/A' }}</span>
                </div>
            </div>
        </div>

        <!-- Customer Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-user text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Customer</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Nama:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $order->customer_name }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Email:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100 break-all">{{ $order->customer_email }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Telepon:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $order->phone_number ?? '-' }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Alamat:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $order->address ?? '-' }}</span>
                </div>
            </div>
        </div>

        <!-- Status Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                    <i class="fas fa-handshake text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Status Serah Terima</h3>
            </div>
            <div class="space-y-2">
                @php
                    $statusConfig = [
                        'pending' => ['bg' => 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300', 'icon' => 'fa-clock'],
                        'ready' => ['bg' => 'bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300', 'icon' => 'fa-box'],
                        'delivered' => ['bg' => 'bg-amber-100 dark:bg-amber-900/40 text-amber-700 dark:text-amber-300', 'icon' => 'fa-truck'],
                        'confirmed' => ['bg' => 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300', 'icon' => 'fa-check-circle'],
                    ];
                    $status = $statusConfig[$order->handover_status ?? 'pending'] ?? $statusConfig['pending'];
                @endphp
                <div class="flex items-center">
                    <span class="inline-flex items-center px-3 py-1.5 rounded-md text-xs font-semibold {{ $status['bg'] }}">
                        <i class="fas {{ $status['icon'] }} mr-1.5 text-xs"></i>
                        {{ $order->handover_status_label }}
                    </span>
                </div>
                @if($order->handover_at)
                <div class="pt-2 border-t border-gray-200 dark:border-gray-700">
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-0.5">Diserahkan pada:</p>
                    <p class="text-xs font-medium text-gray-900 dark:text-white">{{ $order->handover_at->format('d M Y H:i') }}</p>
                </div>
                @endif
                @if($order->customer_confirmed_at)
                <div class="pt-2 border-t border-gray-200 dark:border-gray-700">
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-0.5">Dikonfirmasi pada:</p>
                    <p class="text-xs font-medium text-gray-900 dark:text-white">{{ $order->customer_confirmed_at->format('d M Y H:i') }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Handover Photos Preview -->
    @if($order->handover_photos && count($order->handover_photos) > 0)
    <div class="mb-6 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 transition-colors duration-300 shadow-sm">
        <div class="flex items-center mb-6">
            <div class="p-2.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-3">
                <i class="fas fa-images text-purple-600 dark:text-purple-400 text-base"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Foto Bukti Serah Terima</h3>
            <span class="ml-3 text-sm text-gray-500 dark:text-gray-400">({{ count($order->handover_photos) }} foto)</span>
        </div>
        
        <!-- Photo Grid - Full Images -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-6">
            @foreach($order->handover_photos as $index => $photo)
            <div class="relative group bg-gray-50 dark:bg-gray-900 rounded-xl overflow-hidden border-2 border-gray-200 dark:border-gray-700 hover:border-purple-500 dark:hover:border-purple-400 transition-all duration-300">
                <div class="aspect-video flex items-center justify-center p-4">
                    <img src="{{ asset('uploads/' . $photo) }}" 
                         alt="Foto Bukti Serah Terima {{ $index + 1 }}" 
                         class="max-w-full max-h-full w-auto h-auto object-contain rounded-lg cursor-pointer"
                         onclick="openImageModal('{{ asset('uploads/' . $photo) }}', {{ $index + 1 }})"
                         onerror="this.src='{{ asset('images/no-image.png') }}'">
                </div>
                <div class="absolute top-3 right-3 bg-black/70 backdrop-blur-sm text-white text-xs font-semibold px-3 py-1.5 rounded-full">
                    @if($index === 0)
                        <i class="fas fa-star mr-1 text-yellow-300"></i>Utama
                    @else
                        Foto {{ $index + 1 }}
                    @endif
                </div>
                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors duration-300 flex items-center justify-center">
                    <div class="opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                        <i class="fas fa-expand text-white text-2xl"></i>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        
        @if($order->handover_notes)
        <div class="mt-6 pt-6 border-t border-gray-200 dark:border-gray-700">
            <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-3 flex items-center">
                <i class="fas fa-sticky-note mr-2 text-purple-600 dark:text-purple-400"></i>
                Catatan Serah Terima:
            </h4>
            <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 text-sm text-gray-700 dark:text-gray-300 leading-relaxed">
                {!! nl2br(e($order->handover_notes)) !!}
            </div>
        </div>
        @endif
    </div>
    
    <!-- Image Modal -->
    <div id="imageModal" class="fixed inset-0 bg-black/90 z-50 hidden items-center justify-center p-4" onclick="closeImageModal()">
        <div class="relative max-w-7xl max-h-full w-full h-full flex items-center justify-center">
            <button onclick="closeImageModal()" class="absolute top-4 right-4 text-white hover:text-gray-300 text-3xl z-10 bg-black/50 rounded-full w-12 h-12 flex items-center justify-center hover:bg-black/70 transition-colors">
                <i class="fas fa-times"></i>
            </button>
            <button onclick="changeImage(-1)" class="absolute left-4 text-white hover:text-gray-300 text-2xl z-10 bg-black/50 rounded-full w-12 h-12 flex items-center justify-center hover:bg-black/70 transition-colors">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button onclick="changeImage(1)" class="absolute right-4 text-white hover:text-gray-300 text-2xl z-10 bg-black/50 rounded-full w-12 h-12 flex items-center justify-center hover:bg-black/70 transition-colors">
                <i class="fas fa-chevron-right"></i>
            </button>
            <img id="modalImage" src="" alt="Foto Bukti Serah Terima" class="max-w-full max-h-full object-contain rounded-lg">
            <div class="absolute bottom-4 left-1/2 transform -translate-x-1/2 bg-black/70 backdrop-blur-sm text-white px-4 py-2 rounded-full text-sm">
                <span id="imageCounter"></span>
            </div>
        </div>
    </div>
    
    <script>
        let currentImageIndex = 0;
        const images = [
            @foreach($order->handover_photos as $index => $photo)
            '{{ asset('uploads/' . $photo) }}'{{ $index < count($order->handover_photos) - 1 ? ',' : '' }}
            @endforeach
        ];
        
        function openImageModal(imageSrc, index) {
            currentImageIndex = index - 1;
            document.getElementById('modalImage').src = imageSrc;
            document.getElementById('imageCounter').textContent = `Foto ${index} dari ${images.length}`;
            document.getElementById('imageModal').classList.remove('hidden');
            document.getElementById('imageModal').classList.add('flex');
            document.body.style.overflow = 'hidden';
        }
        
        function closeImageModal() {
            document.getElementById('imageModal').classList.add('hidden');
            document.getElementById('imageModal').classList.remove('flex');
            document.body.style.overflow = 'auto';
        }
        
        function changeImage(direction) {
            currentImageIndex += direction;
            if (currentImageIndex < 0) currentImageIndex = images.length - 1;
            if (currentImageIndex >= images.length) currentImageIndex = 0;
            
            document.getElementById('modalImage').src = images[currentImageIndex];
            document.getElementById('imageCounter').textContent = `Foto ${currentImageIndex + 1} dari ${images.length}`;
        }
        
        // Close on Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeImageModal();
            } else if (e.key === 'ArrowLeft') {
                if (!document.getElementById('imageModal').classList.contains('hidden')) {
                    changeImage(-1);
                }
            } else if (e.key === 'ArrowRight') {
                if (!document.getElementById('imageModal').classList.contains('hidden')) {
                    changeImage(1);
                }
            }
        });
    </script>
    @endif

    <!-- Production Results -->
    @if($order->production && ($order->production->result_photos || $order->production->test_results || $order->production->final_specifications))
    <div class="mb-6 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center mb-4">
            <div class="p-2 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg mr-2">
                <i class="fas fa-camera text-emerald-600 dark:text-emerald-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Hasil Produksi</h3>
        </div>
        <div class="space-y-4">
            @if($order->production->result_photos && count($order->production->result_photos) > 0)
            <div>
                <h4 class="text-xs font-medium text-gray-700 dark:text-gray-300 mb-2">Foto Produk Jadi:</h4>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                    @foreach($order->production->result_photos as $photo)
                    <a href="{{ asset('uploads/' . $photo) }}" target="_blank" class="block">
                        <img src="{{ asset('uploads/' . $photo) }}" alt="Hasil Produksi" 
                             class="w-full h-32 object-cover rounded-lg border border-gray-200 dark:border-gray-600 hover:border-blue-500 dark:hover:border-blue-400 transition-colors"
                             onerror="this.src='{{ asset('images/no-image.png') }}'">
                    </a>
                    @endforeach
                </div>
            </div>
            @endif
            
            @if($order->production->test_results)
            <div>
                <h4 class="text-xs font-medium text-gray-700 dark:text-gray-300 mb-2">Hasil Pengujian:</h4>
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-3 text-xs text-gray-700 dark:text-gray-300">
                    {!! nl2br(e($order->production->test_results)) !!}
                </div>
            </div>
            @endif
            
            @if($order->production->final_specifications)
            <div>
                <h4 class="text-xs font-medium text-gray-700 dark:text-gray-300 mb-2">Spesifikasi Lengkap:</h4>
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-3 text-xs text-gray-700 dark:text-gray-300">
                    {!! nl2br(e($order->production->final_specifications)) !!}
                </div>
            </div>
            @endif
        </div>
    </div>
    @endif

    <!-- Handover Actions -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center mb-4">
            <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                <i class="fas fa-handshake text-indigo-600 dark:text-indigo-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Aksi Serah Terima</h3>
        </div>

        <!-- Actions based on status -->
        @if(!$order->handover_status || $order->handover_status === 'pending')
        <!-- Prepare Handover -->
        <form action="{{ route('admin.handover.prepare', $order) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="space-y-4">
                <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1.5">Foto Bukti Serah Terima</label>
                    <input type="file" name="handover_photos[]" multiple accept="image/*" 
                           class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none dark:bg-gray-700 dark:text-white transition-colors duration-200">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Upload foto produk yang akan diserahkan (bisa multiple)</p>
                </div>
                <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1.5">Catatan Serah Terima</label>
                    <textarea name="handover_notes" rows="3" 
                              class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none dark:bg-gray-700 dark:text-white transition-colors duration-200"
                              placeholder="Catatan tambahan untuk serah terima..."></textarea>
                </div>
                <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-box mr-2"></i>Siapkan untuk Serah Terima
                </button>
            </div>
        </form>

        @elseif($order->handover_status === 'ready')
        <!-- Deliver to Customer -->
        <form action="{{ route('admin.handover.deliver', $order) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @if($order->handover_photos && count($order->handover_photos) > 0)
            <div class="mb-4">
                <p class="text-xs font-medium text-gray-700 dark:text-gray-300 mb-2">Foto yang sudah diupload:</p>
                <div class="flex gap-3 flex-wrap">
                    @foreach($order->handover_photos as $photo)
                    <a href="{{ asset('uploads/' . $photo) }}" target="_blank" class="block">
                        <img src="{{ asset('uploads/' . $photo) }}" alt="Handover Photo" 
                             class="w-24 h-24 object-cover rounded-lg border-2 border-gray-200 dark:border-gray-600 hover:border-blue-500 dark:hover:border-blue-400 transition-colors"
                             onerror="this.src='{{ asset('images/no-image.png') }}'">
                    </a>
                    @endforeach
                </div>
            </div>
            @endif

            <div class="space-y-4">
                <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1.5">Foto Tambahan (opsional)</label>
                    <input type="file" name="additional_photos[]" multiple accept="image/*" 
                           class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none dark:bg-gray-700 dark:text-white transition-colors duration-200">
                </div>
                <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1.5">Catatan</label>
                    <textarea name="handover_notes" rows="2" 
                              class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none dark:bg-gray-700 dark:text-white transition-colors duration-200"
                              placeholder="Catatan tambahan...">{{ $order->handover_notes }}</textarea>
                </div>
                <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1.5">Biaya Pengangkutan &amp; Pengiriman (opsional)</label>
                    <div class="relative">
                        <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-xs text-gray-500 dark:text-gray-400">Rp</span>
                        <input type="number" name="shipping_cost" step="0.01" min="0"
                               class="w-full pl-8 pr-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none dark:bg-gray-700 dark:text-white transition-colors duration-200"
                               placeholder="0">
                    </div>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Nilai ini akan dicatat ke jurnal umum dengan akun 501-04.</p>
                </div>
                <button type="submit" class="w-full px-4 py-2 bg-amber-600 hover:bg-amber-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-truck mr-2"></i>Konfirmasi Penyerahan ke Customer
                </button>
            </div>
        </form>

        @elseif($order->handover_status === 'delivered')
        <!-- Waiting for Customer Confirmation -->
        <div class="text-center py-4">
            <div class="w-16 h-16 mx-auto mb-4 bg-amber-100 dark:bg-amber-900/40 rounded-full flex items-center justify-center">
                <i class="fas fa-hourglass-half text-amber-600 dark:text-amber-400 text-2xl"></i>
            </div>
            <h4 class="text-base font-semibold text-gray-900 dark:text-white mb-2">Menunggu Konfirmasi Customer</h4>
            <p class="text-xs text-gray-600 dark:text-gray-400 mb-4">Produk sudah diserahkan. Menunggu customer mengkonfirmasi penerimaan.</p>
            
            <!-- Link untuk Customer -->
            <div class="mb-6 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
                <p class="text-xs text-blue-800 dark:text-blue-200 mb-2 font-medium">
                    <i class="fas fa-link mr-1"></i> Link Konfirmasi untuk Customer:
                </p>
                <div class="flex items-center gap-2 mb-3">
                    <input type="text" readonly value="{{ route('user.orders.confirm-delivery', $order) }}" 
                           class="flex-1 px-3 py-2 text-xs bg-white dark:bg-gray-700 border border-blue-200 dark:border-blue-700 rounded-lg text-gray-700 dark:text-gray-300"
                           id="customerLink">
                    <button type="button" onclick="copyLink()" class="px-3 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg text-xs transition-colors duration-200">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
                
                <!-- Tombol Kirim ke WA dan Email -->
                <div class="flex flex-col sm:flex-row gap-2">
                    @php
                        // Format nomor telepon untuk WA (hilangkan 0 di depan, tambahkan 62)
                        $phoneNumber = $order->phone_number ?? '';
                        $waNumber = '';
                        if ($phoneNumber) {
                            // Hapus semua karakter non-digit
                            $phoneNumber = preg_replace('/[^0-9]/', '', $phoneNumber);
                            // Jika dimulai dengan 0, ganti dengan 62
                            if (substr($phoneNumber, 0, 1) === '0') {
                                $waNumber = '62' . substr($phoneNumber, 1);
                            } else {
                                $waNumber = $phoneNumber;
                            }
                        }
                        
                        // Format pesan untuk WA
                        $waMessage = urlencode("Halo " . $order->customer_name . ",\n\nProduk pesanan Anda (Order #" . $order->id . ") sudah siap untuk diserahkan.\n\nSilakan konfirmasi penerimaan melalui link berikut:\n" . route('user.orders.confirm-delivery', $order) . "\n\nTerima kasih.");
                        
                        // Format email
                        $emailSubject = urlencode("Konfirmasi Serah Terima - Order #" . $order->id);
                        $emailBody = urlencode("Halo " . $order->customer_name . ",\n\nProduk pesanan Anda (Order #" . $order->id . ") sudah siap untuk diserahkan.\n\nSilakan konfirmasi penerimaan melalui link berikut:\n" . route('user.orders.confirm-delivery', $order) . "\n\nTerima kasih.");
                    @endphp
                    
                    @if($waNumber)
                    <a href="https://wa.me/{{ $waNumber }}?text={{ $waMessage }}" 
                       target="_blank"
                       class="flex-1 inline-flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-xs">
                        <i class="fab fa-whatsapp mr-2 text-sm"></i>
                        Kirim ke WhatsApp
                    </a>
                    @endif
                    
                    @if($order->customer_email)
                    <a href="mailto:{{ $order->customer_email }}?subject={{ $emailSubject }}&body={{ $emailBody }}" 
                       class="flex-1 inline-flex items-center justify-center px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white font-medium rounded-lg transition-colors duration-200 text-xs">
                        <i class="fas fa-envelope mr-2 text-sm"></i>
                        Kirim ke Email
                    </a>
                    @endif
                </div>
                
                @if(!$waNumber && !$order->customer_email)
                <p class="text-xs text-amber-600 dark:text-amber-400 mt-2">
                    <i class="fas fa-exclamation-triangle mr-1"></i>
                    Nomor telepon dan email tidak tersedia. Silakan salin link secara manual.
                </p>
                @endif
            </div>
            
            <!-- Force Complete Button (Emergency) -->
            <div class="pt-4 border-t border-gray-200 dark:border-gray-700">
                <p class="text-xs text-gray-500 dark:text-gray-400 mb-3">Jika customer tidak dapat mengkonfirmasi melalui sistem:</p>
                <form action="{{ route('admin.handover.force-complete', $order) }}" method="POST">
                    @csrf
                    <div class="mb-3">
                        <textarea name="admin_notes" required rows="2" 
                                  class="w-full px-3 py-2 text-xs border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                  placeholder="Alasan konfirmasi oleh admin..."></textarea>
                    </div>
                    <button type="submit" class="w-full px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200 text-xs">
                        <i class="fas fa-check-double mr-2"></i>Konfirmasi Manual oleh Admin
                    </button>
                </form>
            </div>
        </div>
        
        <script>
        function copyLink() {
            const input = document.getElementById('customerLink');
            input.select();
            document.execCommand('copy');
            // Use SweetAlert2 if available, otherwise use alert
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: 'Link berhasil disalin!',
                    timer: 2000,
                    showConfirmButton: false,
                    toast: true,
                    position: 'top-end'
                });
            } else {
                alert('Link berhasil disalin!');
            }
        }
        </script>

        @elseif($order->handover_status === 'confirmed')
        <!-- Completed -->
        <div class="text-center py-4">
            <div class="w-16 h-16 mx-auto mb-4 bg-green-100 dark:bg-green-900/40 rounded-full flex items-center justify-center">
                <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-2xl"></i>
            </div>
            <h4 class="text-base font-semibold text-gray-900 dark:text-white mb-2">Serah Terima Selesai</h4>
            <p class="text-xs text-gray-600 dark:text-gray-400 mb-4">Customer telah mengkonfirmasi penerimaan produk.</p>
            
            @if($order->customer_rating)
            <div class="mb-4">
                <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Rating Customer:</p>
                <div class="flex justify-center gap-1">
                    @for($i = 1; $i <= 5; $i++)
                    <i class="fas fa-star {{ $i <= $order->customer_rating ? 'text-yellow-400' : 'text-gray-300 dark:text-gray-600' }}"></i>
                    @endfor
                </div>
            </div>
            @endif
            
            @if($order->customer_feedback)
            <div class="mb-4 text-left bg-gray-50 dark:bg-gray-700 rounded-lg p-3">
                <p class="text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Feedback Customer:</p>
                <p class="text-xs text-gray-600 dark:text-gray-400">{{ $order->customer_feedback }}</p>
            </div>
            @endif

            <!-- Sale Information -->
            @if($order->sale)
            <div class="mt-4 p-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg">
                <div class="flex items-center mb-2">
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 mr-2"></i>
                    <p class="text-sm font-semibold text-green-800 dark:text-green-200">Penjualan Telah Dicatat</p>
                </div>
                <div class="text-xs text-green-700 dark:text-green-300 space-y-1">
                    <p>Sale ID: #{{ $order->sale->id }}</p>
                    <p>Tanggal Penjualan: {{ $order->sale->sale_date->format('d M Y') }}</p>
                    <p>Status: <span class="font-semibold">{{ $order->sale->status_label }}</span></p>
                </div>
            </div>
            @else
            <div class="mt-4 p-4 bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-lg">
                <div class="flex items-center">
                    <i class="fas fa-exclamation-triangle text-amber-600 dark:text-amber-400 mr-2"></i>
                    <p class="text-xs text-amber-800 dark:text-amber-200">
                        <strong>Catatan:</strong> Sale record belum dibuat. Pastikan status pembayaran dan produksi sudah selesai.
                    </p>
                </div>
            </div>
            @endif
        </div>
        @endif
    </div>
@endsection
