<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Preview - Bukti Serah Terima Order #{{ $order->id }}</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            .print-actions {
                display: none !important;
            }
            body {
                background: #fff !important;
            }
            .print-content {
                box-shadow: none !important;
                padding: 0 !important;
                margin: 0 !important;
            }
        }
        .print-actions {
            backdrop-filter: blur(10px);
        }
    </style>
</head>
<body class="bg-gray-100">
    <!-- Print Actions Bar -->
    <div class="print-actions fixed top-0 left-0 right-0 bg-white/95 shadow-lg z-50 border-b border-gray-200 px-6 py-4">
        <div class="max-w-7xl mx-auto flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-file-alt text-blue-600"></i>
                </div>
                <div>
                    <h1 class="text-lg font-semibold text-gray-800">Preview Bukti Serah Terima</h1>
                    <span class="text-sm text-gray-500">Order #{{ $order->id }} - {{ $order->customer_name }}</span>
                </div>
            </div>
            <div class="flex items-center space-x-3">
                <a href="{{ route('admin.handover.show', $order) }}" 
                   class="inline-flex items-center px-4 py-2 bg-gray-500 hover:bg-gray-600 text-white font-medium rounded-lg transition-all duration-200 shadow-md hover:shadow-lg">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali
                </a>
                <button onclick="window.print()" 
                        class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-all duration-200 shadow-md hover:shadow-lg">
                    <i class="fas fa-print mr-2"></i>
                    Print
                </button>
                <a href="{{ route('admin.handover.print', $order) }}" 
                   class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-all duration-200 shadow-md hover:shadow-lg">
                    <i class="fas fa-download mr-2"></i>
                    Download PDF
                </a>
            </div>
        </div>
    </div>
    
    <!-- Content Spacer -->
    <div class="h-24"></div>
    
    <!-- Print Content -->
    <div class="max-w-4xl mx-auto bg-white shadow-xl print-content p-8 mb-8 rounded-lg">
        @include('admin.handover.print')
    </div>
    
    <!-- Bottom Spacer -->
    <div class="h-8"></div>
</body>
</html>

