@extends('layouts.admin')

@section('title', 'Serah Terima Produk')

@section('content')
    <!-- Notifikasi Modern -->
    <x-admin-notification />

    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Serah Terima Produk</h1>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-6">
        <form method="GET" action="{{ route('admin.handover.index') }}" id="filterForm"
            class="flex flex-col sm:flex-row items-end gap-3">
            <!-- Search Bar -->
            <div class="relative flex-1 w-full sm:w-auto">
                <input type="text" name="search" id="searchInput" value="{{ request('search') }}"
                    placeholder="Cari customer, email, order..." class="form-input-search" />
                <i
                    class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                @if (request('search'))
                    <button type="button" onclick="clearSearch()"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                        <i class="fas fa-times"></i>
                    </button>
                @endif
            </div>

            <!-- Status Filter -->
            <div class="relative w-full sm:w-auto">
                <select name="status" id="statusFilter" onchange="submitFilter()" class="form-select">
                    <option value="">Semua Status</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Menunggu Serah Terima
                    </option>
                    <option value="ready" {{ request('status') === 'ready' ? 'selected' : '' }}>Siap Diserahkan</option>
                    <option value="delivered" {{ request('status') === 'delivered' ? 'selected' : '' }}>Sudah Diserahkan
                    </option>
                    <option value="confirmed" {{ request('status') === 'confirmed' ? 'selected' : '' }}>Dikonfirmasi
                        Customer</option>
                </select>
                <i
                    class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
            </div>
        </form>
    </div>

    <!-- Active Filters Info -->
    @if (request('search') || request('status'))
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>

                @if (request('search'))
                    <span
                        class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-search mr-1"></i>
                        Pencarian: "{{ request('search') }}"
                        <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif

                @if (request('status'))
                    @php
                        $statusLabels = [
                            'pending' => 'Menunggu Serah Terima',
                            'ready' => 'Siap Diserahkan',
                            'delivered' => 'Sudah Diserahkan',
                            'confirmed' => 'Dikonfirmasi Customer',
                        ];
                        $statusLabel = $statusLabels[request('status')] ?? ucfirst(request('status'));
                    @endphp
                    <span
                        class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                        <i class="fas fa-filter mr-1"></i>
                        Status: {{ $statusLabel }}
                        <button onclick="clearFilter('status')" class="ml-2 hover:text-green-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif

                <button onclick="clearAllFilters()"
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    @endif

    <!-- Table Container -->
    <div
        class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th
                            class="w-16 px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            No</th>
                        <th
                            class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Order</th>
                        <th
                            class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Customer</th>
                        <th
                            class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Produk</th>
                        <th
                            class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Qty</th>
                        <th
                            class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Status Handover</th>
                        <th
                            class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($orders as $order)
                        <tr class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200">
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100 text-center align-middle">
                                {{ $loop->iteration + $orders->firstItem() - 1 }}
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 font-medium align-middle">
                                <div class="font-semibold">#{{ $order->id }}</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                    {{ $order->created_at->format('d M Y') }}</div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 align-middle">
                                <div class="font-medium">{{ $order->customer_name }}</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">{{ $order->customer_email }}
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 font-medium align-middle">
                                {{ $order->product->product_title ?? 'N/A' }}
                            </td>
                            <td class="px-4 py-4 text-center text-sm text-gray-900 dark:text-gray-100 align-middle">
                                <span class="font-semibold">{{ $order->quantity }}</span>
                            </td>
                            <td class="px-4 py-4 text-center align-middle">
                                <div class="flex flex-col items-center gap-1.5">
                                    @php
                                        $statusConfig = [
                                            'pending' => [
                                                'bg' => 'bg-gray-100 dark:bg-gray-700',
                                                'text' => 'text-gray-700 dark:text-gray-300',
                                                'icon' => 'fa-clock',
                                            ],
                                            'ready' => [
                                                'bg' => 'bg-blue-100 dark:bg-blue-900/40',
                                                'text' => 'text-blue-700 dark:text-blue-300',
                                                'icon' => 'fa-box',
                                            ],
                                            'delivered' => [
                                                'bg' => 'bg-amber-100 dark:bg-amber-900/40',
                                                'text' => 'text-amber-700 dark:text-amber-300',
                                                'icon' => 'fa-truck',
                                            ],
                                            'confirmed' => [
                                                'bg' => 'bg-green-100 dark:bg-green-900/40',
                                                'text' => 'text-green-700 dark:text-green-300',
                                                'icon' => 'fa-check-circle',
                                            ],
                                        ];
                                        $status =
                                            $statusConfig[$order->handover_status ?? 'pending'] ??
                                            $statusConfig['pending'];
                                    @endphp
                                    <span
                                        class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md {{ $status['bg'] }} {{ $status['text'] }}">
                                        <i class="fas {{ $status['icon'] }} text-xs"></i>
                                        <span>{{ $order->handover_status_label }}</span>
                                    </span>
                                    @if ($order->handover_status === 'confirmed' && $order->sale)
                                        <span
                                            class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                            <i class="fas fa-check-double text-xs"></i>
                                            <span>Sale #{{ $order->sale->id }}</span>
                                        </span>
                                    @elseif($order->handover_status === 'confirmed' && !$order->sale)
                                        <span
                                            class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded bg-amber-100 dark:bg-amber-900/40 text-amber-700 dark:text-amber-300">
                                            <i class="fas fa-exclamation-triangle text-xs"></i>
                                            <span>Belum Sale</span>
                                        </span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-4 py-4 text-center align-middle">
                                <a href="{{ route('admin.handover.show', $order) }}"
                                    class="inline-flex items-center justify-center w-9 h-9 text-indigo-600 dark:text-indigo-400 hover:text-indigo-700 dark:hover:text-indigo-300 hover:bg-indigo-50 dark:hover:bg-indigo-900/20 rounded transition-colors duration-200"
                                    title="Detail">
                                    <i class="fas fa-eye text-base"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div
                                        class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
                                        <i class="fas fa-inbox text-2xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 text-lg font-medium">Tidak ada order yang
                                        siap untuk serah terima</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm mt-1">Order yang siap akan muncul di
                                        sini</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        @if ($orders->hasPages())
            <div
                class="flex items-center justify-between px-4 py-3 border-t border-gray-200 dark:border-gray-700 text-sm bg-gray-50 dark:bg-gray-800">
        
                <!-- Info -->
                <div class="text-gray-600 dark:text-gray-400">
                    Menampilkan
                    <span class="font-medium">{{ $orders->firstItem() }}</span>
                    –
                    <span class="font-medium">{{ $orders->lastItem() }}</span>
                    dari
                    <span class="font-medium">{{ $orders->total() }}</span>
                    data order
                </div>
        
                <!-- Pagination -->
                <div>
                    {{ $orders->onEachSide(1)->links() }}
                </div>
            </div>
        @endif

    </div>

    <script>
        // Submit filter dengan parameter yang bersih
        function submitFilter() {
            const params = new URLSearchParams();

            // Ambil nilai dari setiap input/select
            const search = document.getElementById('searchInput')?.value?.trim() || '';
            const status = document.getElementById('statusFilter')?.value || '';

            // Hanya tambahkan parameter yang memiliki nilai
            if (search) {
                params.append('search', search);
            }
            if (status) {
                params.append('status', status);
            }

            // Redirect dengan parameter yang bersih
            const url = '{{ route('admin.handover.index') }}' + (params.toString() ? '?' + params.toString() : '');
            window.location.href = url;
        }

        // Clear search only
        function clearSearch() {
            const url = new URL(window.location);
            url.searchParams.delete('search');
            window.location.href = url.toString();
        }

        // Clear individual filter
        function clearFilter(filterName) {
            const url = new URL(window.location);
            url.searchParams.delete(filterName);
            window.location.href = url.toString();
        }

        // Clear all filters
        function clearAllFilters() {
            window.location.href = '{{ route('admin.handover.index') }}';
        }

        // Submit form search dengan Enter
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        submitFilter();
                    }
                });
            }
        });
    </script>

    <style>
        /* Custom scrollbar untuk tabel */
        .overflow-x-auto::-webkit-scrollbar {
            height: 8px;
        }

        .overflow-x-auto::-webkit-scrollbar-track {
            background: #f1f5f9;
            border-radius: 4px;
        }

        .overflow-x-auto::-webkit-scrollbar-thumb {
            background: #cbd5e0;
            border-radius: 4px;
        }

        .overflow-x-auto::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        /* Dark mode scrollbar */
        .dark .overflow-x-auto::-webkit-scrollbar-track {
            background: #374151;
        }

        .dark .overflow-x-auto::-webkit-scrollbar-thumb {
            background: #6b7280;
        }

        .dark .overflow-x-auto::-webkit-scrollbar-thumb:hover {
            background: #9ca3af;
        }

        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }

        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }

        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }

        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }

        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }

        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }

        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
    </style>
@endsection
