@extends('layouts.admin')

@section('title', 'Chart of Accounts')

@section('content')
    <!-- Notifikasi -->
    <x-admin-notification />

    <!-- Header -->
    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">
                Chart of Accounts
            </h1>
            <p class="text-sm text-gray-500 dark:text-gray-400">
                Master data akun/perkiraan untuk laporan keuangan
            </p>
        </div>

        <div class="flex items-center gap-2">
            <a href="{{ route('admin.chart-of-accounts.create') }}"
                class="inline-flex items-center gap-2 px-4 py-2 rounded-lg
                       bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium transition">
                <i class="fas fa-plus"></i>
                Tambah Akun
            </a>
            <form method="POST" action="{{ route('admin.chart-of-accounts.seed-standard') }}">
                @csrf
                <button type="submit"
                    class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-green-600 hover:bg-green-700 text-white text-sm font-medium transition">
                    <i class="fas fa-seedling"></i>
                    Tambah Akun Standar
                </button>
            </form>
        </div>
    </div>

    <!-- Filter -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-6">
        <form method="GET" action="{{ route('admin.chart-of-accounts.index') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Cari</label>
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Kode atau Nama Akun"
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Pos Laporan</label>
                <select name="pos_laporan" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Semua</option>
                    <option value="NERACA" {{ request('pos_laporan') == 'NERACA' ? 'selected' : '' }}>NERACA</option>
                    <option value="LABA RUGI" {{ request('pos_laporan') == 'LABA RUGI' ? 'selected' : '' }}>LABA RUGI</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Pos Saldo</label>
                <select name="pos_saldo" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Semua</option>
                    <option value="DEBET" {{ request('pos_saldo') == 'DEBET' ? 'selected' : '' }}>DEBET</option>
                    <option value="KREDIT" {{ request('pos_saldo') == 'KREDIT' ? 'selected' : '' }}>KREDIT</option>
                </select>
            </div>
            <div class="flex items-end gap-2">
                <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200">
                    <i class="fas fa-search mr-2"></i>Filter
                </button>
                <a href="{{ route('admin.chart-of-accounts.index') }}" class="px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200">
                    <i class="fas fa-redo"></i>
                </a>
            </div>
        </form>
    </div>

    <!-- Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Kode Akun</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Nama Akun</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tabel Bantuan</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Pos Saldo</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Pos Laporan</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Saldo Awal Debet</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Saldo Awal Kredit</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Status</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($accounts as $account)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-white">{{ $account->kode_akun }}</td>
                            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-300">{{ $account->nama_akun }}</td>
                            <td class="px-4 py-3 text-sm text-center text-gray-700 dark:text-gray-300">{{ $account->tabel_bantuan ?? '-' }}</td>
                            <td class="px-4 py-3 text-sm text-center">
                                <span class="px-2 py-1 text-xs font-medium rounded {{ $account->pos_saldo == 'DEBET' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' : 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' }}">
                                    {{ $account->pos_saldo }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-sm text-center">
                                <span class="px-2 py-1 text-xs font-medium rounded {{ $account->pos_laporan == 'NERACA' ? 'bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200' : 'bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-200' }}">
                                    {{ $account->pos_laporan }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-sm text-right text-gray-700 dark:text-gray-300">
                                {{ $account->saldo_awal_debet > 0 ? number_format($account->saldo_awal_debet, 0, ',', '.') : '-' }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right text-gray-700 dark:text-gray-300">
                                {{ $account->saldo_awal_kredit > 0 ? number_format($account->saldo_awal_kredit, 0, ',', '.') : '-' }}
                            </td>
                            <td class="px-4 py-3 text-center">
                                <span class="px-2 py-1 text-xs font-medium rounded {{ $account->is_active ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' }}">
                                    {{ $account->is_active ? 'Aktif' : 'Nonaktif' }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-center">
                                <div class="flex items-center justify-center gap-2">
                                    <a href="{{ route('admin.chart-of-accounts.show', $account) }}" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.chart-of-accounts.edit', $account) }}" class="text-yellow-600 hover:text-yellow-800 dark:text-yellow-400 dark:hover:text-yellow-300" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.chart-of-accounts.destroy', $account) }}" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menghapus akun ini?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-800 dark:text-red-400 dark:hover:text-red-300" title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="px-4 py-8 text-center text-sm text-gray-500 dark:text-gray-400">
                                Tidak ada data akun
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination (Inside Container, Tipis) --}}
        @if ($accounts->hasPages())
            <div
                class="flex items-center justify-between px-4 py-3 border-t border-gray-200 dark:border-gray-700 text-sm">

                {{-- Info --}}
                <div class="text-gray-600 dark:text-gray-400">
                    Menampilkan
                    <span class="font-medium">{{ $accounts->firstItem() }}</span>
                    –
                    <span class="font-medium">{{ $accounts->lastItem() }}</span>
                    dari
                    <span class="font-medium">{{ $accounts->total() }}</span>
                    data
                </div>

                {{-- Pagination --}}
                <div>
                    {{ $accounts->onEachSide(1)->links() }}
                </div>
            </div>
        @endif

    </div>
@endsection

