@extends('layouts.admin')

@section('title', 'Detail Pengeluaran')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.backoffice.expense.index') }}"
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Pengeluaran #{{ $expense->id }}</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    {{ $expense->transaction_date ? $expense->transaction_date->format('d M Y') : '-' }}
                </p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <a href="{{ route('admin.backoffice.expense.edit', $expense->id) }}"
                class="inline-flex items-center justify-center w-9 h-9 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                title="Edit">
                <i class="fas fa-edit text-base"></i>
            </a>
            <form id="delete-form-{{ $expense->id }}"
                action="{{ route('admin.backoffice.expense.destroy', $expense->id) }}" method="POST"
                class="inline m-0 p-0" onsubmit="return confirmDelete(event, {{ $expense->id }})">
                @csrf
                @method('DELETE')
                <button type="submit"
                    class="inline-flex items-center justify-center w-9 h-9 text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/20 rounded transition-colors duration-200"
                    title="Hapus">
                    <i class="fas fa-trash text-base"></i>
                </button>
            </form>
        </div>
    </div>

    <!-- Success/Error Messages -->
    @if (session('success'))
        <div class="mb-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg text-sm">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        </div>
    @endif

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-4">
        <!-- Informasi Transaksi -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-red-100 dark:bg-red-900/40 rounded-lg mr-2">
                    <i class="fas fa-info-circle text-red-600 dark:text-red-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Transaksi</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Kategori:</span>
                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-red-100 text-red-800 dark:bg-red-900/40 dark:text-red-300">
                        {{ $expense->category_name ?? ($expense->category ?? '-') }}
                    </span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Tanggal:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $expense->transaction_date ? $expense->transaction_date->format('d M Y') : '-' }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">No. Ref:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $expense->reference_number ?? '-' }}</span>
                </div>
            </div>
        </div>

        <!-- Detail Pengeluaran -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-money-bill-wave text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Detail Pengeluaran</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Jumlah:</span>
                    <span class="text-xs font-semibold text-red-600 dark:text-red-400">{{ $expense->formatted_amount }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Deskripsi:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ Str::limit($expense->description ?? '-', 40) }}</span>
                </div>
            </div>
        </div>

        <!-- Informasi Sistem -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-gray-100 dark:bg-gray-700 rounded-lg mr-2">
                    <i class="fas fa-user text-gray-600 dark:text-gray-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Sistem</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Dibuat:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $expense->created_at->format('d M Y H:i') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Oleh:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $expense->creator->name ?? 'Tidak diketahui' }}</span>
                </div>
                @if($expense->updated_at != $expense->created_at)
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Diupdate:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $expense->updated_at->format('d M Y H:i') }}</span>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Deskripsi & Catatan -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 mb-4">
        <!-- Deskripsi Lengkap -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                    <i class="fas fa-align-left text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Deskripsi</h3>
            </div>
            <p class="text-sm text-gray-700 dark:text-gray-300">{{ $expense->description ?? '-' }}</p>
        </div>

        <!-- Catatan -->
        @if($expense->notes)
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg mr-2">
                    <i class="fas fa-sticky-note text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Catatan</h3>
            </div>
            <p class="text-sm text-gray-700 dark:text-gray-300 whitespace-pre-line">{{ $expense->notes }}</p>
        </div>
        @endif
    </div>

    <!-- Lampiran -->
    @if($expense->attachment && file_exists(public_path('storage/' . $expense->attachment)))
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center mb-3">
            <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-2">
                <i class="fas fa-paperclip text-purple-600 dark:text-purple-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Lampiran</h3>
        </div>
        <div class="flex items-center gap-4">
            <a href="{{ asset('storage/' . $expense->attachment) }}" target="_blank"
                class="inline-flex items-center px-3 py-1.5 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-download mr-2 text-xs"></i>
                <span>Download</span>
            </a>
            @php
                $extension = strtolower(pathinfo($expense->attachment, PATHINFO_EXTENSION));
            @endphp
            @if (in_array($extension, ['jpg', 'jpeg', 'png', 'gif', 'webp']))
                <div class="flex items-center gap-2">
                    <img src="{{ asset('storage/' . $expense->attachment) }}" alt="Lampiran Gambar"
                        class="w-20 h-20 object-cover rounded-lg border border-gray-200 dark:border-gray-600">
                    <span class="text-xs text-gray-600 dark:text-gray-400">Preview</span>
                </div>
            @elseif ($extension === 'pdf')
                <div class="flex items-center gap-2">
                    <div class="w-20 h-20 bg-red-100 dark:bg-red-900/40 rounded-lg border border-gray-200 dark:border-gray-600 flex items-center justify-center">
                        <i class="fas fa-file-pdf text-red-600 dark:text-red-400 text-xl"></i>
                    </div>
                    <span class="text-xs text-gray-600 dark:text-gray-400">PDF Document</span>
                </div>
            @endif
        </div>
    </div>
    @endif

    <script>
        function confirmDelete(event, id) {
            event.preventDefault();
            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: "Data ini akan dihapus secara permanen!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#e3342f',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
            return false;
        }
    </script>
@endsection
