// Tooltip Fix untuk Admin Tables - Versi Sederhana dan Fokus
document.addEventListener('DOMContentLoaded', function() {
    console.log('Tooltip Fix JS loaded'); // Debug
    
    // Event listener untuk semua tooltip di tabel
    document.querySelectorAll('.tooltip-fix').forEach(function(tooltipElement) {
        const tooltipContent = tooltipElement.querySelector('.tooltip-content');
        
        if (tooltipContent) {
            console.log('Found tooltip element:', tooltipElement); // Debug
            
            // Event mouseenter - Pastikan tooltip terikat dengan elemen yang benar
            tooltipElement.addEventListener('mouseenter', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                console.log('Mouse enter tooltip on:', tooltipElement); // Debug
                
                // Pastikan tooltip terikat dengan elemen yang benar
                const rect = tooltipElement.getBoundingClientRect();
                
                // Reset semua style terlebih dahulu
                tooltipContent.style.cssText = '';
                
                // Set posisi tooltip dengan !important - tepat di bawah tombol yang di-hover
                tooltipContent.style.setProperty('position', 'absolute', 'important');
                tooltipContent.style.setProperty('top', '100%', 'important');
                tooltipContent.style.setProperty('left', '50%', 'important');
                tooltipContent.style.setProperty('transform', 'translateX(-50%)', 'important');
                tooltipContent.style.setProperty('margin-top', '8px', 'important');
                tooltipContent.style.setProperty('z-index', '999999', 'important');
                tooltipContent.style.setProperty('opacity', '1', 'important');
                tooltipContent.style.setProperty('visibility', 'visible', 'important');
                tooltipContent.style.setProperty('pointer-events', 'none', 'important');
                tooltipContent.style.setProperty('background-color', '#1f2937', 'important');
                tooltipContent.style.setProperty('color', 'white', 'important');
                tooltipContent.style.setProperty('padding', '8px 12px', 'important');
                tooltipContent.style.setProperty('border-radius', '6px', 'important');
                tooltipContent.style.setProperty('font-size', '12px', 'important');
                tooltipContent.style.setProperty('font-weight', '500', 'important');
                tooltipContent.style.setProperty('white-space', 'nowrap', 'important');
                tooltipContent.style.setProperty('box-shadow', '0 4px 6px -1px rgba(0, 0, 0, 0.1)', 'important');
                tooltipContent.style.setProperty('min-width', '60px', 'important');
                tooltipContent.style.setProperty('text-align', 'center', 'important');
                
                // Tambahkan arrow dengan pseudo-element
                if (!tooltipContent.querySelector('.tooltip-arrow')) {
                    const arrow = document.createElement('div');
                    arrow.className = 'tooltip-arrow';
                    arrow.style.cssText = `
                        position: absolute !important;
                        top: -6px !important;
                        left: 50% !important;
                        transform: translateX(-50%) !important;
                        width: 0 !important;
                        height: 0 !important;
                        border-left: 6px solid transparent !important;
                        border-right: 6px solid transparent !important;
                        border-bottom: 6px solid #1f2937 !important;
                    `;
                    tooltipContent.appendChild(arrow);
                }
            });
            
            // Event mouseleave
            tooltipElement.addEventListener('mouseleave', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                console.log('Mouse leave tooltip'); // Debug
                
                tooltipContent.style.setProperty('opacity', '0', 'important');
                tooltipContent.style.setProperty('visibility', 'hidden', 'important');
            });
        }
    });
    
    // Fallback: Jika JavaScript tidak bekerja, gunakan CSS hover
    setTimeout(function() {
        document.querySelectorAll('.tooltip-fix').forEach(function(tooltipElement) {
            const tooltipContent = tooltipElement.querySelector('.tooltip-content');
            if (tooltipContent) {
                // Tambahkan class untuk CSS fallback
                tooltipElement.classList.add('js-tooltip-enabled');
            }
        });
    }, 100);
});