document.addEventListener("DOMContentLoaded", function () {
    const slides = document.querySelectorAll(".slide");
    const prevBtn = document.getElementById("prev");
    const nextBtn = document.getElementById("next");

    // Hanya jalankan slider jika ada lebih dari 1 slide dan tombol navigasi ada
    if (slides.length > 1 && prevBtn && nextBtn) {
        let currentSlide = 0;

        function showSlide(index) {
            slides.forEach((slide, i) => {
                slide.classList.remove("active");
                slide.style.opacity = "0";
                if (i === index) {
                    slide.classList.add("active");
                    slide.style.opacity = "1";
                }
            });
        }

        nextBtn.addEventListener("click", () => {
            currentSlide = (currentSlide + 1) % slides.length;
            showSlide(currentSlide);
        });

        prevBtn.addEventListener("click", () => {
            currentSlide = (currentSlide - 1 + slides.length) % slides.length;
            showSlide(currentSlide);
        });

        setInterval(() => {
            currentSlide = (currentSlide + 1) % slides.length;
            showSlide(currentSlide);
        }, 5000);

        showSlide(currentSlide);
    } else if (slides.length === 1) {
        // Jika hanya ada 1 slide, pastikan slide pertama aktif
        slides[0].classList.add("active");
        slides[0].style.opacity = "1";
    }
});

// Category Carousel Navigation
    document.addEventListener('DOMContentLoaded', function() {
        const carousel = document.getElementById('categoryCarousel');
        
        if (carousel) {
            const slides = carousel.querySelectorAll('.category-slide');
            const prevBtn = carousel.querySelector('.category-nav-prev');
            const nextBtn = carousel.querySelector('.category-nav-next');
            let currentSlide = 0;

            function showSlide(index) {
                slides.forEach((slide, i) => {
                    slide.classList.remove('active');
                    if (i === index) {
                        slide.classList.add('active');
                    }
                });
            }

            if (prevBtn) {
                prevBtn.addEventListener('click', function() {
                    currentSlide = (currentSlide - 1 + slides.length) % slides.length;
                    showSlide(currentSlide);
                });
            }

            if (nextBtn) {
                nextBtn.addEventListener('click', function() {
                    currentSlide = (currentSlide + 1) % slides.length;
                    showSlide(currentSlide);
                });
            }
        }
    });

 function toggleDropdown(id, iconId) {
        const dropdown = document.getElementById(id);
        const icon = document.getElementById(iconId);

        dropdown.classList.toggle('hidden');
        dropdown.classList.toggle('block');
        icon.classList.toggle('rotate-180');
    }

