<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            // Spareparts received tracking (mirip dengan materials_status)
            $table->string('spareparts_status', 50)->nullable()->default('pending')->after('materials_received_by')->comment('pending, preparing, received, rejected');
            $table->timestamp('spareparts_received_at')->nullable()->after('spareparts_status');
            $table->foreignId('spareparts_received_by')->nullable()->constrained('users')->onDelete('set null')->after('spareparts_received_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->dropForeign(['spareparts_received_by']);
            $table->dropColumn([
                'spareparts_status',
                'spareparts_received_at',
                'spareparts_received_by'
            ]);
        });
    }
};
