<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            // Materials received tracking
            $table->string('materials_status', 50)->nullable()->default('pending')->after('planning_status')->comment('pending, preparing, received, rejected');
            $table->timestamp('materials_received_at')->nullable()->after('materials_status');
            $table->foreignId('materials_received_by')->nullable()->constrained('users')->onDelete('set null')->after('materials_received_at');
            
            // Estimation fields
            $table->integer('estimated_duration_days')->nullable()->after('materials_received_by')->comment('Estimasi hari pengerjaan dari product');
            $table->integer('material_preparation_days')->nullable()->default(2)->after('estimated_duration_days')->comment('Waktu persiapan bahan (default 2 hari)');
            $table->date('actual_start_date')->nullable()->after('start_date')->comment('Tanggal mulai sebenarnya (saat bahan diterima)');
            $table->date('estimated_completion_date')->nullable()->after('actual_start_date')->comment('Estimasi tanggal selesai');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->dropForeign(['materials_received_by']);
            $table->dropColumn([
                'materials_status',
                'materials_received_at',
                'materials_received_by',
                'estimated_duration_days',
                'material_preparation_days',
                'actual_start_date',
                'estimated_completion_date'
            ]);
        });
    }
};
