<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->decimal('labor_cost', 15, 2)->nullable()->after('total_production_cost')->comment('Upah pengerjaan');
            $table->string('completion_status', 50)->nullable()->after('status')->comment('pending_approval, approved, rejected');
            $table->timestamp('completed_at')->nullable()->after('end_date');
            $table->timestamp('completion_approved_at')->nullable()->after('completed_at');
            $table->foreignId('completion_approved_by')->nullable()->constrained('users')->onDelete('set null')->after('completion_approved_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->dropForeign(['completion_approved_by']);
            $table->dropColumn(['labor_cost', 'completion_status', 'completed_at', 'completion_approved_at', 'completion_approved_by']);
        });
    }
};
