<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->string('planning_status')->default('planning')->after('status'); // planning, pending_approval, approved, rejected
            $table->text('supervisor_feedback')->nullable()->after('notes');
            $table->timestamp('submitted_at')->nullable()->after('assigned_at');
            $table->timestamp('approved_at')->nullable()->after('submitted_at');
            $table->unsignedBigInteger('approved_by')->nullable()->after('approved_at');
            
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productions', function (Blueprint $table) {
            $table->dropForeign(['approved_by']);
            $table->dropColumn(['planning_status', 'supervisor_feedback', 'submitted_at', 'approved_at', 'approved_by']);
        });
    }
};
