<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add damaged_stock field to materials table
        Schema::table('materials', function (Blueprint $table) {
            $table->integer('damaged_stock')->default(0)->after('stock');
            $table->text('damage_notes')->nullable()->after('damage_date');
        });

        // Add damaged_stock field to spareparts table
        Schema::table('spareparts', function (Blueprint $table) {
            $table->integer('damaged_stock')->default(0)->after('stock');
            $table->text('damage_notes')->nullable()->after('damage_date');
        });

        // Add damaged_stock field to products table
        Schema::table('products', function (Blueprint $table) {
            $table->integer('damaged_stock')->default(0)->after('product_prices');
            $table->text('damage_notes')->nullable()->after('damaged_stock');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('materials', function (Blueprint $table) {
            $table->dropColumn(['damaged_stock', 'damage_notes']);
        });

        Schema::table('spareparts', function (Blueprint $table) {
            $table->dropColumn(['damaged_stock', 'damage_notes']);
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['damaged_stock', 'damage_notes']);
        });
    }
};