<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add condition field to materials table
        Schema::table('materials', function (Blueprint $table) {
            $table->enum('condition', ['new', 'good', 'fair', 'poor', 'damaged'])->default('new')->after('is_active');
            $table->text('damage_reason')->nullable()->after('condition');
            $table->timestamp('damage_date')->nullable()->after('damage_reason');
        });

        // Add condition field to spareparts table
        Schema::table('spareparts', function (Blueprint $table) {
            $table->enum('condition', ['new', 'good', 'fair', 'poor', 'damaged'])->default('new')->after('is_active');
            $table->text('damage_reason')->nullable()->after('condition');
            $table->timestamp('damage_date')->nullable()->after('damage_reason');
        });

        // Add condition field to products table
        Schema::table('products', function (Blueprint $table) {
            $table->enum('condition', ['new', 'good', 'fair', 'poor', 'damaged'])->default('new')->after('is_active');
            $table->text('damage_reason')->nullable()->after('condition');
            $table->timestamp('damage_date')->nullable()->after('damage_reason');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('materials', function (Blueprint $table) {
            $table->dropColumn(['condition', 'damage_reason', 'damage_date']);
        });

        Schema::table('spareparts', function (Blueprint $table) {
            $table->dropColumn(['condition', 'damage_reason', 'damage_date']);
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['condition', 'damage_reason', 'damage_date']);
        });
    }
};