<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_opnames', function (Blueprint $table) {
            $table->id();

            // Opname Info
            $table->string('opname_number', 50)->unique()->comment('Nomor stock opname: SO-202410-001');
            $table->date('opname_date')->comment('Tanggal pelaksanaan stock opname');

            // Status
            $table->enum('status', ['draft', 'completed'])
                ->default('draft')
                ->comment('Status: draft = belum approve, completed = sudah approve');

            // Notes
            $table->text('notes')->nullable()->comment('Catatan stock opname');

            // User Tracking
            $table->foreignId('created_by')
                ->constrained('users')
                ->onDelete('restrict')
                ->comment('User yang membuat');

            $table->foreignId('approved_by')
                ->nullable()
                ->constrained('users')
                ->onDelete('restrict')
                ->comment('User yang approve');

            $table->timestamp('approved_at')
                ->nullable()
                ->comment('Waktu approve');

            // Timestamps
            $table->timestamps();
            $table->softDeletes(); // Audit trail

            // Indexes untuk performa query
            $table->index('status');
            $table->index('opname_date');
            $table->index('created_by');
            $table->index(['status', 'opname_date']); // Composite index
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_opnames');
    }
};
