<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('purchase_id')->constrained()->onDelete('cascade');
            $table->unsignedBigInteger('item_id')->nullable(); // id bahan / sparepart
            $table->string('item_type'); // material / sparepart
            $table->string('item_name'); // nama barang
            $table->integer('quantity'); // jumlah beli
            $table->decimal('unit_price', 15, 2); // harga per unit
            $table->decimal('total_price', 15, 2); // qty * harga
            $table->string('unit')->nullable(); // satuan (kg, pcs, dll)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_items');
    }
};
