<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
            $table->string('purchase_code')->unique(); // kode unik pembelian
            $table->date('purchase_date'); // tanggal pembelian
            $table->string('supplier_name')->nullable(); // nama toko / tempat beli
            $table->enum('purchase_type', ['material', 'sparepart']); // jenis barang
            $table->decimal('total_amount', 15, 2)->default(0); // total semua item
            $table->text('notes')->nullable(); // catatan tambahan
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};
