<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('production_materials', function (Blueprint $table) {
            $table->id();

            // Relasi ke produksi dan bahan
            $table->foreignId('production_id')->constrained('productions')->onDelete('cascade');
            $table->foreignId('material_id')->constrained('materials')->onDelete('cascade');

            // Detail penggunaan bahan
            $table->integer('quantity')->default(1);       // jumlah bahan yang digunakan
            $table->string('unit')->nullable();            // satuan (kg, liter, lembar, dll)
            $table->decimal('unit_cost', 15, 2)->nullable(); // harga satuan bahan (saat produksi)
            $table->decimal('total_cost', 15, 2)->nullable(); // total = quantity * unit_cost

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('production_materials');
    }
};
