<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('spareparts', function (Blueprint $table) {
            $table->id();
            $table->string('part_code')->unique()->nullable(); // kode unik sparepart
            $table->string('name');
            $table->string('brand')->nullable(); // merek sparepart
            $table->string('type')->nullable(); // tipe/model sparepart
            $table->string('part_number')->nullable(); // nomor seri sparepart
            $table->integer('stock')->default(0);
            $table->string('unit')->nullable(); // pcs, set, box
            $table->decimal('price', 15, 2)->nullable(); // per unit
            $table->string('image')->nullable(); // foto sparepart
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('spareparts');
    }
};
