<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('product_title')->nullable();
            $table->string('product_image')->nullable();
            $table->longText('product_description')->nullable();
            // $table->integer('product_quantity')->nullable();
            $table->integer('product_prices')->nullable();
            $table->unsignedBigInteger('category_id')->nullable(); // relasi ke tabel categories
            $table->string('product_work_duration')->nullable();
            $table->string('product_garansi')->nullable();
            $table->timestamps();

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
