<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    use HasFactory;

    protected $fillable = [
        'purchase_code',
        'purchase_date',
        'supplier_name',
        'supplier_id',
        'purchase_type',
        'total_amount',
        'status',
        'notes',
        'supervisor_feedback',
        'approved_at',
        'approved_by',
    ];

    /**
     * The attributes that should be cast.
     */
    protected $casts = [
        'purchase_date' => 'date',
        'total_amount' => 'decimal:2',
        'approved_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function items()
    {
        return $this->hasMany(PurchaseItem::class);
    }

    public function purchaseItems()
    {
        return $this->hasMany(PurchaseItem::class);
    }

    /**
     * Get supplier name - menggunakan field supplier_name karena tidak ada model Supplier terpisah
     */
    public function getSupplierAttribute()
    {
        return $this->supplier_name;
    }

    public function supervisor()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
