<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'kode_bantu',
        'nama_proyek',
        'tabel_bantuan',
        'nilai_kontrak',
        'tanggal_mulai',
        'tanggal_selesai',
        'status',
        'keterangan',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'nilai_kontrak' => 'decimal:2',
        'tanggal_mulai' => 'date',
        'tanggal_selesai' => 'date',
        'is_active' => 'boolean',
        'sort_order' => 'integer',
    ];

    /**
     * Relationship with JournalEntry
     */
    public function journalEntries(): HasMany
    {
        return $this->hasMany(JournalEntry::class, 'kd_project', 'kode_bantu');
    }

    /**
     * Scope untuk proyek aktif
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope untuk filter berdasarkan status
     */
    public function scopeByStatus($query, $status)
    {
        return $query->where('status', $status);
    }

    public static function generateNextCode(): string
    {
        $last = static::orderBy('kode_bantu', 'desc')->first();
        if ($last && preg_match('/^P(\d+)/', $last->kode_bantu, $m)) {
            $num = (int) $m[1] + 1;
        } else {
            $num = 1;
        }

        return 'P' . str_pad((string) $num, 2, '0', STR_PAD_LEFT);
    }
}
