<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductSpecification extends Model
{
    protected $fillable = ['product_id', 'key', 'value'];

    public function product()
    {
        return $this->belongsTo(\App\Models\Product::class);
    }

    // Accessor untuk view
    public function getSpecTextAttribute()
    {
        return $this->key . ': ' . $this->value;
    }
}
