<?php

namespace App\Mail;

use App\Models\Notification;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NotificationEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $notification;

    /**
     * Create a new message instance.
     */
    public function __construct(Notification $notification)
    {
        $this->notification = $notification;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('[POLJAM TECH] ' . $this->notification->title)
                    ->view('emails.notification')
                    ->with([
                        'notification' => $this->notification,
                        'title' => $this->notification->title,
                        'message' => $this->notification->message,
                        'data' => $this->notification->data,
                        'type' => $this->notification->type,
                    ]);
    }
}

