<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class HandoverDeliveredEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $order;

    /**
     * Create a new message instance.
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('[POLJAM TECH] Konfirmasi Serah Terima Produk - Order #' . $this->order->id)
                    ->view('emails.handover-delivered')
                    ->with([
                        'order' => $this->order,
                    ]);
    }
}

