<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserContactController extends Controller
{
    /**
     * Display the specified contact
     */
    public function show($id)
    {
        try {
            $user = Auth::user();
            
            if (!$user) {
                abort(401, 'Silakan login terlebih dahulu.');
            }
            
            $email = $user->email;
            
            // Find contact and check authorization
            $contact = Contact::where('id', $id)
                ->where('email', $email)
                ->first();
            
            if (!$contact) {
                // Check if contact exists but belongs to different user
                $exists = Contact::where('id', $id)->exists();
                if ($exists) {
                    abort(403, 'Anda tidak memiliki akses ke pesan kontak ini.');
                }
                abort(404, 'Pesan kontak tidak ditemukan.');
            }

            // Jangan update is_read di sini!
            // is_read hanya untuk admin, bukan untuk user
            // User hanya melihat status apakah admin sudah membaca atau belum

            return view('user.contacts.show', compact('contact'));
        } catch (\Exception $e) {
            \Log::error('Error in UserContactController@show: ' . $e->getMessage());
            abort(500, 'Terjadi kesalahan saat memuat data.');
        }
    }
}

