<?php

namespace App\Http\Controllers\Teknisi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Material;

class MaterialController extends Controller
{
    public function index(Request $request)
    {
        $query = Material::where('is_active', true);

        // Search filter
        if ($request->filled('search') && trim($request->search) !== '') {
            $search = trim($request->search);
            $query->where(function($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%')
                    ->orWhere('description', 'like', '%' . $search . '%')
                    ->orWhere('category', 'like', '%' . $search . '%')
                    ->orWhere('supplier', 'like', '%' . $search . '%')
                    ->orWhere('material_code', 'like', '%' . $search . '%');
            });
        }

        // Filter by stock status
        if ($request->filled('stock_status')) {
            if ($request->stock_status === 'low') {
                $query->where('stock', '<=', 10);
            } elseif ($request->stock_status === 'medium') {
                $query->where('stock', '>', 10)->where('stock', '<=', 50);
            } elseif ($request->stock_status === 'safe') {
                $query->where('stock', '>', 50);
            }
        }

        // Filter by category
        if ($request->filled('category')) {
            $query->where('category', $request->category);
        }

        $materials = $query->latest()->paginate(15);
        $materials->appends($request->only(['search', 'stock_status', 'category']));

        // Get unique categories for filter dropdown
        $categories = Material::where('is_active', true)
            ->whereNotNull('category')
            ->distinct()
            ->pluck('category')
            ->sort()
            ->values();

        return view('teknisi.materials.index', compact('materials', 'categories'));
    }
}
























