<?php

namespace App\Helpers;

class SecurityHelper
{
    public static function sanitizeInput(mixed $value): mixed
    {
        if (is_string($value)) {
            return trim(strip_tags($value));
        }

        if (is_array($value)) {
            return array_map([self::class, 'sanitizeInput'], $value);
        }

        return $value;
    }

    public static function sanitizeArray(array $data): array
    {
        return array_map([self::class, 'sanitizeInput'], $data);
    }

    public static function sanitizeRequest(\Illuminate\Http\Request $request): \Illuminate\Http\Request
    {
        $sanitized = self::sanitizeArray($request->all());
        $request->merge($sanitized);

        return $request;
    }
}

